if (typeof(jQuery.fn.w2dpicturegrid)=='undefined') {

	jQuery.fn.w2dpicturegrid = function(options) {
		
		var settings = {
			grow: 10,
			speed: 150
		}	
		
		if (options) {
			$.extend(settings, options);
		}
		
			
		$(this).children('.w2dpicturegridcontainer').mouseover(function() {
			if (typeof(this.w2doriginalleft)=='undefined') {
				this.w2doriginalleft=parseInt(this.style.left);
				this.w2doriginaltop=parseInt(this.style.top);
				this.w2doriginalwidth=parseInt(this.style.width);
				this.w2doriginalheight=parseInt(this.style.height);
			}
			
			$(this).parent().children('.w2dpicturegridcontainer').css('z-index', 2);
			$(this).css('z-index',3);
			
			$(this).find('.w2dpicturegridsmall').stop().animate({
				'width': this.w2doriginalwidth+2*settings.grow+'px',
				'height': this.w2doriginalheight+2*settings.grow+'px'
			}, {
				duration: settings.speed,	
				easing: 'w2dpicturegrideasing'
			})		
					
			$(this).stop().animate({
				'left': this.w2doriginalleft-settings.grow+'px',
				'top': this.w2doriginaltop-settings.grow+'px',
				'width': this.w2doriginalwidth+2*settings.grow+'px',
				'height': this.w2doriginalheight+2*settings.grow+'px'
			}, {
				duration: settings.speed,	
				easing: 'w2dpicturegrideasing'
			})
		});
		
		$(this).children('.w2dpicturegridcontainer').mouseout(function() {
			$(this).find('.w2dpicturegridsmall').stop().animate({
				'width': this.w2doriginalwidth+'px',
				'height': this.w2doriginalheight+'px'
			}, {
				duration: settings.speed,
				easing: 'w2dpicturegrideasing'
			})		
			$(this).stop().animate({
				'left': this.w2doriginalleft+'px',
				'top': this.w2doriginaltop+'px',
				'width': this.w2doriginalwidth+'px',
				'height': this.w2doriginalheight+'px'
			}, {
				duration: settings.speed,
				easing: 'w2dpicturegrideasing'
			})		
		})
		
		$(this).find('.w2dpicturegridpicturelink').click(function() {
			var outer=this.href.split('#');
			var filename=outer[0];
			var inner=outer[1].split('x');
			var picwidth=parseInt(inner[0]);		
			var picheight=parseInt(inner[1]);
			
			w2dpopupboxinstance.showImage(picwidth, picheight, filename);
			
			return false;
		});
		
	};

	/*
	 * A special easing
	 */
	jQuery.extend(jQuery.easing, {
		w2dpicturegrideasing: function(x, t, b, c, d){
			if ((t /= d / 2) < 1) 
				return c / 2 * t * t + b;
			return -c / 2 * ((--t) * (t - 2) - 1) + b;
		}
	});
}