////////////////////////////////////////////////////////////////////////////
//
// Projekt: shop to date 6 ImageZoom Plugin
// Autor: Volker Sauer, (C) 2008
// etor Softwareentwicklung e.K.
// Bottroper Str. 19, 45899 Gelsenkirchen, sauer@etor.de
//
// Datei: ImageZoom API
// Version: 1.2
// Art: Javascript
// Inhalt: Klasse ImageZoom + Instanz
// Beschreibung: Zeigt Bildauschnitt an
// Bentigt: Nichts
// Letzte nderung:
// 16.02.2009: Bugfix positioned Elemente
//
////////////////////////////////////////////////////////////////////////////

// KONFIGURATION Gre und Dicke des Ausschnittsrahmens
var ZOOM_WIDTH = 100;
var ZOOM_HEIGHT = 100;
var ZOOM_BORDERWIDTH = 2;

// Browserweiche Version 1.3
function iz_browser() {
	this.ie = false;
	this.gecko = false;
	this.opera = false;
	this.safari = false;
	this.iequirks = false;

	var agent = navigator.userAgent.toLowerCase();
	if (agent.indexOf('opera') != -1) {
		this.opera = true;
	} else if (agent.indexOf('msie') != -1) {
		this.ie = true;
		if (document.compatMode == 'BackCompat')
			this.iequirks = true;
	} else if (agent.indexOf('safari') != -1) {
		this.gecko = true;
	} else if (agent.indexOf('gecko') != -1 && agent.indexOf('khtml') == -1) {
		this.gecko = true;
	}
}

function getStyle(el, styleProp) {
	if (el.currentStyle)
		var val = el.currentStyle[styleProp];
	else if (window.getComputedStyle)
		var val = document.defaultView.getComputedStyle(el, null).getPropertyValue(styleProp);
	return val;
}

function get_positionedOffsetLeft(obj) {
	var cur = 0;
	if (obj.offsetParent)
		do {
			cur += obj.offsetLeft;
		} while ((obj = obj.offsetParent) && getStyle(obj, 'position') == 'static');
	return cur;
}

function get_positionedOffsetTop(obj) {
	var cur = 0;
	if (obj.offsetParent)
		do {
			cur += obj.offsetTop;
		} while ((obj = obj.offsetParent) && getStyle(obj, 'position') == 'static');
	return cur;
}

function get_realOffsetLeft(obj) {
	var cur = 0;
	if (obj.offsetParent)
		do {
			cur += obj.offsetLeft;
		} while (obj = obj.offsetParent);
	return cur;
}

function get_realOffsetTop(obj) {
	var cur = 0;
	if (obj.offsetParent)
		do {
			cur += obj.offsetTop;
		} while (obj = obj.offsetParent);
	return cur;
}

// Browser Instanz
var iz_ua = new iz_browser();

function imagezoom(img_id) {
	var id = img_id;
	var preview = document.getElementById('iz_preview_' + id);
	var preview_x;
	var preview_y;
	var preview_w;
	var preview_h;

	var original = document.getElementById('iz_original_' + id);
	var original_w, original_h;

	var border = document.getElementById('iz_border_' + id);
	border.style.borderWidth = ZOOM_BORDERWIDTH + 'px';
	border.style.width = (ZOOM_WIDTH - (iz_ua.iequirks ? 0 : ZOOM_BORDERWIDTH * 2)) + 'px';
	border.style.height = (ZOOM_HEIGHT - (iz_ua.iequirks ? 0 : ZOOM_BORDERWIDTH * 2)) + 'px';

	var container = document.getElementById('iz_container_' + id);
	var container_w, container_h;

	//var zoomed_image;
	var on_image = 0;

	this.start = function() {
		if (!on_image) {
			on_image = 1;
			container_w = container.offsetWidth;
			container_h = container.offsetHeight;
			original_w = original.offsetWidth;
			original_h = original.offsetHeight;
			preview_x = get_positionedOffsetLeft(preview);
			preview_y = get_positionedOffsetTop(preview);
			viewport_x = get_realOffsetLeft(preview);
			viewport_y = get_realOffsetTop(preview);
			preview_w = preview.offsetWidth;
			preview_h = preview.offsetHeight;
			container.style.left = (preview_x + preview.offsetWidth + 20) + 'px';
			container.style.top = preview_y  + 'px';
			border.style.visibility = 'visible';
			container.style.visibility = 'visible';
			if (iz_ua.ie)
				document.attachEvent("onmousemove", this.move);
			else
				addEventListener("mousemove", this.move, false);
		}
	}

	this.stop = function() {
		on_image = 0;
		zoomed_image = null;
		border.style.visibility = 'hidden';
		container.style.visibility = 'hidden';
		if (iz_ua.ie)
			document.detachEvent("onmousemove", this.move);
		else
			removeEventListener("mousemove", this.move, false);
	}

	this.move = function(event) {
		var event = event || window.event;
		var mouse_x = iz_ua.ie ? event.clientX + Math.max(document.documentElement.scrollLeft, document.body.scrollLeft) : event.pageX;
		var mouse_y = iz_ua.ie ? event.clientY + Math.max(document.documentElement.scrollTop, document.body.scrollTop) : event.pageY;
		var x = mouse_x - viewport_x;
		var y = mouse_y - viewport_y;

		// Begrenzungen
		zx = Math.max(x, ZOOM_WIDTH / 2);
		zy = Math.max(y, ZOOM_HEIGHT / 2);
		zx = Math.min(zx, preview_w - ZOOM_WIDTH / 2);
		zy = Math.min(zy, preview_h - ZOOM_WIDTH / 2);

		bx = Math.max(x, ZOOM_WIDTH / 2 - 2);
		by = Math.max(y, ZOOM_HEIGHT / 2 - 2);
		bx = Math.min(bx, preview_w - ZOOM_WIDTH / 2 + 2);
		by = Math.min(by, preview_h - ZOOM_WIDTH / 2 + 2);

		// Rahmen versetzen
		border.style.left = (preview_x + bx - ZOOM_WIDTH / 2) + 'px';
		border.style.top = (preview_y + by - ZOOM_HEIGHT / 2) + 'px';

		// Auschnitt verschieben
		var new_x = (zx - ZOOM_WIDTH / 2) * (original_w - container_w) / (preview_w - ZOOM_WIDTH);
		var new_y = (zy - ZOOM_HEIGHT / 2) * (original_h - container_h) / (preview_h - ZOOM_HEIGHT);
		original.style.top = (-new_y) + 'px';
		original.style.left = (-new_x) + 'px';
	}

	document.getElementById('iz_preview_' + id).onmouseover = function() {
		iz_array[id].start();
	}
}


